#!/bin/bash

echo "=============================="
echo " Assetto Corsa Server Manager "
echo "         Setup Script"
echo "=============================="
echo

# Check executable
if [ -f "./acsm" ]; then
    FILE="./acsm"
elif [ -f "./acsm.py" ]; then
    FILE="./acsm.py"
else
    echo "❌ acsm or acsm.py not found in the current directory."
    echo "➡️  Place the acsm executable (or acsm.py) in this folder and run again."
    exit 1
fi

# Install to /usr/local/bin
echo "⚙️ Installing acsm to /usr/local/bin..."
if [ "$(id -u)" != "0" ]; then
    echo "(Root privileges required — you may be prompted for your password.)"
    sudo cp "$FILE" /usr/local/bin/acsm
    sudo chmod +x /usr/local/bin/acsm
else
    cp "$FILE" /usr/local/bin/acsm
    chmod +x /usr/local/bin/acsm
fi

echo
echo "✅ Setup complete!"
echo "You can now use 'acsm' from anywhere."
echo
echo "Examples:"
echo "  acsm add"
echo "  acsm start <server_name>"
echo "  acsm stop <server_name>"
echo "  acsm logs <server_name>"
echo
echo "🎉 Assetto Corsa Server Manager installed successfully!"
