#!/bin/bash

echo "=============================="
echo " Assetto Corsa Server Manager"
echo "        セットアップ開始"
echo "=============================="
echo

# 実行ファイルを確認
if [ -f "./acsm" ]; then
    FILE="./acsm"
elif [ -f "./acsm.py" ]; then
    FILE="./acsm.py"
else
    echo "❌ acsm または acsm.py がこのフォルダに見つかりません。"
    echo "➡️  acsm 実行ファイルをこのフォルダに置いてから再実行してください。"
    exit 1
fi

# /usr/local/bin にコピー
echo "⚙️ acsm を /usr/local/bin にインストールしています..."
if [ "$(id -u)" != "0" ]; then
    echo "（管理者権限が必要なためパスワードを求められることがあります）"
    sudo cp "$FILE" /usr/local/bin/acsm
    sudo chmod +x /usr/local/bin/acsm
else
    cp "$FILE" /usr/local/bin/acsm
    chmod +x /usr/local/bin/acsm
fi

# 完了メッセージ
echo
echo "✅ セットアップ完了！"
echo "これで 'acsm' コマンドがどこからでも実行できます。"
echo
echo "使い方の例："
echo "  acsm add"
echo "  acsm start <サーバー名>"
echo "  acsm stop <サーバー名>"
echo "  acsm logs <サーバー名>"
echo
echo "🎉 Assetto Corsa Server Manager のインストールが完了しました！"
